//Caption: Program to Compute the Autocorrelation of a Sequence
//And verfication of Autocorrelation property
clc;
clear;
close;
x = input('Enter the input Sequence:=');
m = length(x);
lx = input('Enter the lower index of input sequence:=')
hx = lx+m-1;
n = lx:1:hx;
x_fold = x($:-1:1);
nx = lx+lx;
nh = nx+m+m-2;
r = nx:nh;
Rxx = convol(x,x_fold);
disp(Rxx,'Auto Correlation Rxx[n]:=')
//Property 1: Autocorrelation of a sequence has even symmetry
//Rxx[n] = Rxx[-n]
Rxx_flip = Rxx([$:-1:1]);
if Rxx_flip==Rxx then
    disp('Property 1:Auto Correlation has Even Symmetry');
    disp(Rxx_flip,'Auto Correlation time reversed Rxx[-n]:=');
end
//Property 2: Center value Rxx[0]= total power of the sequence
Tot_Px = sum(x.^2);
Mid = ceil(length(Rxx)/2);
if Tot_Px == Rxx(Mid) then
    disp('Property 2:Rxx[0]=center value=max. value=Total power of i/p sequence');
end
subplot(2,1,1)
plot2d3('gnn',n,x)
xlabel('n===>')
ylabel('Amplitude-->')
title('Input Sequence x[n]')
subplot(2,1,2)
plot2d3('gnn',r,Rxx)
xlabel('n===>')
ylabel('Amplitude-->')
title('Auto correlation Sequence Rxx[n]')
//Example
//Enter the input Sequence:=[2,-1,3,4,1]
//
//Enter the lower index of input sequence:=-2
// 
// Auto Correlation Rxx[n]:=   
// 
//    2.    7.    5.    11.    31.    11.    5.    7.    2.  
// 
// Property 1:Auto Correlation has Even Symmetry   
// 
// Auto Correlation time reversed Rxx[-n]:=   
// 
//    2.    7.    5.    11.    31.    11.    5.    7.    2.  
// 
// Property 2:Rxx[0]=center value=max. value=Total power of i/p sequence   
